/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmClientModule;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ClientHandler;
import svenhjol.charm.base.helper.ScreenHelper;
import svenhjol.charm.client.PortableCraftingClient;
import svenhjol.charm.client.PortableEnderChestClient;

public class InventoryButtonClient
extends CharmClientModule {
    public ImageButton recipeButton;
    private boolean hasHiddenRecipeButton = false;
    public PortableCraftingClient portableCraftingClient;
    public PortableEnderChestClient portableEnderChestClient;

    public InventoryButtonClient(CharmModule module) {
        super(module);
    }

    @Override
    public void init() {
        this.portableCraftingClient = (PortableCraftingClient)ClientHandler.getModule("portable_crafting");
        this.portableEnderChestClient = (PortableEnderChestClient)ClientHandler.getModule("portable_ender_chest");
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!(event.getGui() instanceof InventoryScreen) || event.getGui() instanceof CreativeScreen) {
            return;
        }
        if (!event.getWidgetList().isEmpty() && event.getWidgetList().get(0) instanceof ImageButton) {
            this.recipeButton = (ImageButton)event.getWidgetList().get(0);
        }
        this.redrawButtons((InventoryScreen)event.getGui());
    }

    @SubscribeEvent
    public void onDrawForeground(GuiContainerEvent.DrawForeground event) {
        if (!(event.getGuiContainer() instanceof InventoryScreen) || event.getGuiContainer() instanceof CreativeScreen) {
            return;
        }
        this.redrawButtons((InventoryScreen)event.getGuiContainer());
    }

    private void redrawButtons(InventoryScreen screen) {
        int left = ScreenHelper.getX(screen);
        if (this.portableCraftingClient != null && this.portableCraftingClient.isButtonVisible()) {
            if (this.portableEnderChestClient.isButtonVisible()) {
                if (this.recipeButton != null) {
                    this.recipeButton.field_230694_p_ = false;
                    this.hasHiddenRecipeButton = true;
                }
                this.portableCraftingClient.craftingButton.func_191746_c(left + 104, this.portableCraftingClient.craftingButton.field_230691_m_);
                this.portableEnderChestClient.chestButton.func_191746_c(left + 130, this.portableEnderChestClient.chestButton.field_230691_m_);
            } else {
                if (this.recipeButton != null && this.hasHiddenRecipeButton) {
                    this.recipeButton.field_230694_p_ = true;
                    this.hasHiddenRecipeButton = false;
                }
                this.portableCraftingClient.craftingButton.func_191746_c(left + 130, this.portableCraftingClient.craftingButton.field_230691_m_);
            }
        } else if (this.portableEnderChestClient != null && this.portableEnderChestClient.isButtonVisible()) {
            if (this.recipeButton != null && this.hasHiddenRecipeButton) {
                this.recipeButton.field_230694_p_ = true;
                this.hasHiddenRecipeButton = false;
            }
            this.portableEnderChestClient.chestButton.func_191746_c(left + 130, this.portableEnderChestClient.chestButton.field_230691_m_);
        }
    }
}

